<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->longText('description')->nullable();
            $table->json('benefits')->nullable();
            $table->longText('targets')->nullable();
            $table->json('features')->nullable();
            $table->string('video_url')->nullable();
            $table->string('image_url')->nullable();
            $table->string('image_target_url')->nullable();
            $table->string('url_confluence')->nullable();
            $table->string('slug')->unique();
            $table->boolean('is_active')->default(true);
            // $table->foreignId('menu_id')->nullable()->constrained('menus')->onDelete('set null');
            $table->foreignId('menu_id')->nullable()->constrained('menus')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
